/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mod.beethoven92.betterendforge.client.model.EndSlimeEntityModel;
import mod.beethoven92.betterendforge.common.entity.EndSlimeEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.AbstractEyesLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class EndSlimeEntityRenderer
extends MobRenderer<EndSlimeEntity, EndSlimeEntityModel<EndSlimeEntity>> {
    private static final ResourceLocation[] TEXTURE = new ResourceLocation[4];
    private static final RenderType[] GLOW = new RenderType[4];

    public EndSlimeEntityRenderer(EntityRendererManager entityRenderDispatcher) {
        super(entityRenderDispatcher, new EndSlimeEntityModel(false), 0.25f);
        this.func_177094_a(new OverlayFeatureRenderer(this));
        this.func_177094_a((LayerRenderer)new AbstractEyesLayer<EndSlimeEntity, EndSlimeEntityModel<EndSlimeEntity>>((IEntityRenderer)this){

            public RenderType func_225636_a_() {
                return GLOW[0];
            }

            public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EndSlimeEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                IVertexBuilder vertexConsumer = bufferIn.getBuffer(GLOW[entitylivingbaseIn.getSlimeType()]);
                ((EndSlimeEntityModel)this.func_215332_c()).func_225598_a_(matrixStackIn, vertexConsumer, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                if (entitylivingbaseIn.isLake()) {
                    ((EndSlimeEntityModel)this.func_215332_c()).renderFlower(matrixStackIn, vertexConsumer, 0xF00000, OverlayTexture.field_229196_a_);
                }
            }
        });
    }

    public ResourceLocation getEntityTexture(EndSlimeEntity entity) {
        return TEXTURE[entity.getSlimeType()];
    }

    public void render(EndSlimeEntity slimeEntity, float f, float g, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int i) {
        this.field_76989_e = 0.25f * (float)slimeEntity.func_70809_q();
        super.func_225623_a_((MobEntity)slimeEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    protected void preRenderCallback(EndSlimeEntity slimeEntity, MatrixStack matrixStack, float partialTickTime) {
        matrixStack.func_227862_a_(0.999f, 0.999f, 0.999f);
        matrixStack.func_227861_a_(0.0, (double)0.001f, 0.0);
        float h = slimeEntity.func_70809_q();
        float i = MathHelper.func_219799_g((float)partialTickTime, (float)slimeEntity.field_70812_c, (float)slimeEntity.field_70811_b) / (h * 0.5f + 1.0f);
        float j = 1.0f / (i + 1.0f);
        matrixStack.func_227862_a_(j * h, 1.0f / j * h, j * h);
    }

    static {
        EndSlimeEntityRenderer.TEXTURE[0] = new ResourceLocation("betterendforge", "textures/entity/end_slime/end_slime.png");
        EndSlimeEntityRenderer.TEXTURE[1] = new ResourceLocation("betterendforge", "textures/entity/end_slime/end_slime_mossy.png");
        EndSlimeEntityRenderer.TEXTURE[2] = new ResourceLocation("betterendforge", "textures/entity/end_slime/end_slime_lake.png");
        EndSlimeEntityRenderer.TEXTURE[3] = new ResourceLocation("betterendforge", "textures/entity/end_slime/end_slime_amber.png");
        EndSlimeEntityRenderer.GLOW[0] = RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("betterendforge", "textures/entity/end_slime/end_slime_glow.png"));
        EndSlimeEntityRenderer.GLOW[1] = GLOW[0];
        EndSlimeEntityRenderer.GLOW[2] = RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("betterendforge", "textures/entity/end_slime/end_slime_lake_glow.png"));
        EndSlimeEntityRenderer.GLOW[3] = RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("betterendforge", "textures/entity/end_slime/end_slime_amber_glow.png"));
    }

    private final class OverlayFeatureRenderer<T extends EndSlimeEntity>
    extends LayerRenderer<T, EndSlimeEntityModel<T>> {
        private final EndSlimeEntityModel<T> modelOrdinal;
        private final EndSlimeEntityModel<T> modelLake;

        public OverlayFeatureRenderer(IEntityRenderer<T, EndSlimeEntityModel<T>> featureRendererContext) {
            super(featureRendererContext);
            this.modelOrdinal = new EndSlimeEntityModel(true);
            this.modelLake = new EndSlimeEntityModel(true);
        }

        public void render(MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int packedLightIn, T livingEntity, float f, float g, float h, float j, float k, float l) {
            if (!livingEntity.func_82150_aj()) {
                IVertexBuilder vertexConsumer;
                if (((EndSlimeEntity)((Object)livingEntity)).isLake()) {
                    vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.func_229139_a_((Entity)livingEntity)));
                    ((EndSlimeEntityModel)this.func_215332_c()).renderFlower(matrixStack, vertexConsumer, packedLightIn, LivingRenderer.func_229117_c_(livingEntity, (float)0.0f));
                } else if (((EndSlimeEntity)((Object)livingEntity)).isAmber() || ((EndSlimeEntity)((Object)livingEntity)).isChorus()) {
                    vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.func_229139_a_((Entity)livingEntity)));
                    ((EndSlimeEntityModel)this.func_215332_c()).renderCrop(matrixStack, vertexConsumer, packedLightIn, LivingRenderer.func_229117_c_(livingEntity, (float)0.0f));
                }
                EndSlimeEntityModel<T> model = ((EndSlimeEntity)((Object)livingEntity)).getSlimeType() == 1 ? this.modelLake : this.modelOrdinal;
                ((EndSlimeEntityModel)this.func_215332_c()).func_217111_a((EntityModel)model);
                model.func_212843_a_((Entity)livingEntity, f, g, h);
                model.setRotationAngles(livingEntity, f, g, j, k, l);
                IVertexBuilder vertexConsumer2 = vertexConsumerProvider.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.func_229139_a_((Entity)livingEntity)));
                model.func_225598_a_(matrixStack, vertexConsumer2, packedLightIn, LivingRenderer.func_229117_c_(livingEntity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

